// create a preview class
local CPreview	=	OOP_Derive( CUserMessage, CThink, CUtility );


// constructor
function CPreview:__ctor( )
	// setup the class.
	self.Entities = {};
	self.Cache = {};
	self.Started = false;
	self.EntityCount = 0;
	self.Filename = "";
	self.Copy = false;
	
	// hook
	self:HookMessage( "AddPreviewEntity" );
	self:HookMessage( "ClearPreview" );
//	self:HookMessage( "ShowPreview" );	// - Deprecated
	self:HookMessage( "InitPreview" );

end


// start preview.
function CPreview:Start( )
	// start.
	self.Started = true;
	
	// we're done with the bar.
	ProgressWindow:HideProgressDisplay();
	
	// make the preview visible.
	local ent;
	for _, ent in pairs( self.Entities ) do
		if( ent.entity:IsValid() ) then
			// set color.
			ent.entity:SetColor( ent.color.x, ent.color.y, ent.color.z, 80 );
			
		end
		
	end

end

// clear
function CPreview:Clear( )
	// remove all existing entities in the preview.
	local ent;
	for _, ent in pairs( self.Entities ) do
		if( ent.entity:IsValid() ) then ent.entity:Remove(); end
		
	end
	
	// reset
	self.Entities = {};
	self.Started = false;
	
	// hide the progress display.
	ProgressWindow:HideProgressDisplay();

end

// add entity
function CPreview:AddEntity( origin, angles, color, model, rendermode, cached )
	// decrement how many entities we have left.
	self.EntityCount = self.EntityCount - 1;

	// add an entity to the progressbar.
	ProgressWindow:IncrementProgress();
	
	// update status bar.
	if( self.EntityCount > 0 ) then
		// update status.
		ProgressWindow:SetStatus( "Generating preview [" .. self.EntityCount .. " entities remaining]" );
	
	// it's done.
	else
		// hide bar.
		ProgressWindow:HideProgressDisplay();
		
		// HACK HACK
		timer.Simple(
			// delay
			0.1,
			
			// function
			self.Start,
			
			// args
			self
		);
	
	end
	
	// add to cache?
	if( VMFSuite.Config['cache'] && !cached ) then
		// add
		table.insert(
			self.Cache[ self.Filename ],
			{
				origin = origin,
				angles = angles,
				model = model,
				color = color,
				rendermode = rendermode,
			}
		);
		
	end
	
	// not visible?
	if( rendermode == RENDERMODE_NONE ) then return; end
	
	// Create the preview entity.
	local ent = ents.Create( "prop_physics" );
	if( !ent || !ent:IsValid() ) then return; end
	
	// fix rendermode.
	if( rendermode != RENDERMODE_TRANSALPHA ) then rendermode = RENDERMODE_TRANSALPHA; end
	
	// setup ent preview.
	util.PrecacheModel( model );
	ent:SetModel( model );
	ent:SetPos( origin );
	ent:SetAngles( angles );
	
	// spawn.
	ent:Spawn();
	ent:Activate();
	
	// make intangible & translucent.
	ent:SetSolid( SOLID_VPHYSICS );
	ent:SetMoveType( MOVETYPE_NONE );
	ent:SetNotSolid( true );
	ent:SetRenderMode( rendermode );
	
	// debub, make the preview visible while it builds?
	local previewalpha = 0;
	if( VMFSuite.Debug ) then previewalpha = 20; end
	ent:SetColor( color.x, color.y, color.z, previewalpha );
	
	// insert.
	table.insert(
		self.Entities,
		{
			entity = ent,
			origin = origin,
			angles = angles,
			color = color,
		}
	);

end



// think
function CPreview:OnThink( )
	// do we entities to preview?
	if( table.getn( self.Entities ) <= 0 ) then return; end
	
	// trace, figure out where to stick the sucker.
	local trace = {
		start = LocalPlayer():GetShootPos(),
		endpos = LocalPlayer():GetShootPos() + LocalPlayer():GetAimVector() * 4096,
		filter = LocalPlayer(),
	};
	local tr = util.TraceLine( trace );
	
	
	// grab user translation and rotation.
	local rotation = Angle(
		VMFSuite.ConVars['rotation'].pitch:GetFloat(),
		VMFSuite.ConVars['rotation'].yaw:GetFloat(),
		VMFSuite.ConVars['rotation'].roll:GetFloat()
	);
	local translation = Vector(
		VMFSuite.ConVars['offset'].x:GetFloat(),
		VMFSuite.ConVars['offset'].y:GetFloat(),
		VMFSuite.ConVars['offset'].z:GetFloat()
	);
	
	
	// should we use surface normals for alignment?
	local surface_normal, surface_angle;
	if( VMFSuite.ConVars['surface_align']:GetBool() ) then
		// store normal
		surface_normal = tr.HitNormal;
		
		// calculate angle
		surface_angle = surface_normal:Angle();
		surface_angle.pitch = surface_angle.pitch + 90;
	
	end
	
	
	// position entities.
	local ent;
	for _, ent in pairs( self.Entities ) do
		// fix the position
		local pos = self:FixupVector(
			tr.HitPos,
			rotation,
			ent.origin,
			translation,
			surface_normal,
			surface_angle
		);
		
		// fix the angle
		local ang = self:FixupAngle(
			ent.angles,
			rotation,
			surface_normal,
			surface_angle
		);
		
		// Place.
		ent.entity:SetPos( pos );
		ent.entity:SetAngles( ang );
		
	end
	
	
end


// AddPreviewEntity
function CPreview:OnAddPreviewEntity( msg )
	// read model.
	local model = msg:ReadString();
	
	// read angles and origin.
	local origin = msg:ReadVector();
	local angles = msg:ReadVector();
	
	// read color.
	local color = msg:ReadVector();
	local rendermode = msg:ReadShort();
	
	// add entity.
	self:AddEntity(
		origin,
		angles,
		color,
		model,
		rendermode,
		!self.Copy
	);
	
end

// ClearPreview
function CPreview:OnClearPreview( msg )
	// clear
	self:Clear();
	
end

/* ShowPreview - Deprecated
function CPreview:OnShowPreview( msg )

end */

// InitPreview
function CPreview:OnInitPreview( msg )
	// fetch.
	local entities = msg:ReadShort();
	local filename = msg:ReadString();
	local copy = msg:ReadBool();
	
	// has this preview been completed and cached?
	if( VMFSuite.Config['cache'] && !copy && self.Cache[ filename ] && table.getn( self.Cache[ filename ] ) >= entities ) then
		// reject the preview from the server we already have it.
		LocalPlayer():ConCommand( "VMF_HaltPreview\n" );
		
		//
		self.Filename = filename;
		
		// load from cache.
		local data;
		for _, data in pairs( self.Cache[ filename ] ) do
			// add entity.
			self:AddEntity(
				data.origin,
				data.angles,
				data.color,
				data.model,
				data.rendermode,
				true
			);
		
		end
		
		// start the preview.
		self:Start();
	
	// not cached or cache is incomplete.
	else
		// setup the preview
		self.Filename = filename;
		self.EntityCount = entities;
		self.Copy = copy;
		
		// create a cache entry if it's enabled.
		if( VMFSuite.Config['cache'] && !copy ) then
			self.Cache[ filename ] = {};
		
		end
		
		// setup the progress bar.
		ProgressWindow:InitProgressBar( 0, entities );
		ProgressWindow:ShowProgressDisplay();
		
		// accept the preview.
		LocalPlayer():ConCommand( "VMF_AcceptPreview\n" );
	
	end
	
end

// create
local preview = CPreview:create();

